/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity.container;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMealSlot;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotResultSlot;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModContainerTypes;

public class CookingPotContainer
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOWL = new ResourceLocation("farmersdelight", "item/empty_container_slot_bowl");
    public final CookingPotBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData cookingPotData;
    private final ContainerLevelAccess canInteractWithCallable;

    public CookingPotContainer(int windowId, Inventory playerInventory, CookingPotBlockEntity tileEntity, ContainerData cookingPotDataIn) {
        super((MenuType)ModContainerTypes.COOKING_POT.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.cookingPotData = cookingPotDataIn;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 30;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 3; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new CookingPotMealSlot((IItemHandler)this.inventory, 6, 124, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 7, 92, 55){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CONTAINER_SLOT_BOWL);
            }
        });
        this.m_38897_((Slot)new CookingPotResultSlot(playerInventory.f_35978_, tileEntity, (IItemHandler)this.inventory, 8, 124, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(cookingPotDataIn);
    }

    private static CookingPotBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof CookingPotBlockEntity) {
            return (CookingPotBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public CookingPotContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CookingPotContainer.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean m_6875_(Player playerIn) {
        return CookingPotContainer.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)ModBlocks.COOKING_POT.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 6;
        int indexContainerInput = 7;
        int indexOutput = 8;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == indexOutput) {
                if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index > indexOutput) {
                if (itemstack1.m_41720_() == Items.f_42399_ && !this.m_38903_(itemstack1, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 0, indexMealDisplay, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, indexContainerInput, indexOutput, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.cookingPotData.m_6413_(0);
        int j = this.cookingPotData.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.tileEntity.isHeated();
    }
}

